// Datasheet:https://www.analog.com/media/en/technical-documentation/data-sheets/DS18B20.pdf

char TEXT_TEMPERATURE[]="TMPC";
signed short ReadDS18B20(){
  unsigned short tempDataMSB, tempDataLSB;
  signed short temperature=0, buffer;

  Ow_Reset(&PORTE,0);             // Reset
  Ow_Write(&PORTE,0,0xCC);        // Skip ROM
  Ow_Write(&PORTE,0,0x44);        // Convert Temperature
  Delay_ms(750);

  Ow_Reset(&PORTE,0);             // Reset
  Ow_Write(&PORTE,0,0xCC);        // Skip ROM
  Ow_Write(&PORTE,0,0xBE);        // Read Scratchpad

  tempDataLSB=Ow_Read(&PORTE,0);    // Read LSB
  tempDataMSB=Ow_Read(&PORTE,0);    // Read MSB

  temperature=tempDataMSB<<4;
  temperature+=(tempDataLSB>>4);

  if(temperature<-55 || temperature>125)
    return 0;



  if(temperature<0){               // If temp is negative
    TEXT_TEMPERATURE[0]='-';      // negative sign
    buffer=-temperature;
  }
  else{
    buffer=temperature;
    TEXT_TEMPERATURE[0]=buffer/100+48;
    if(TEXT_TEMPERATURE[0]=='0')
      TEXT_TEMPERATURE[0]=' ';
  }

  TEXT_TEMPERATURE[1]=(buffer%100)/10+48;
  if(TEXT_TEMPERATURE[0]==' ' && TEXT_TEMPERATURE[1]=='0')
      TEXT_TEMPERATURE[1]=' ';
  TEXT_TEMPERATURE[2]=buffer%10+48;
    
  return temperature;
}